import { getPreferences } from "../../preferences/getPreferences";
import { query } from "../../util/apiRequest";

export const refresh = async (
    access_token,
    URL,
    dispatch,
    fetchStart,
    getDataSuccess
) => {
    dispatch(getPreferences());
    try {
        dispatch(fetchStart());
        const data = await query(URL, "GET", access_token);
        const { status: { code } = {}, records } = data?.response;
        if (code === 200) {
            dispatch(getDataSuccess(records?.data));
        } else {
            dispatch(getDataSuccess([]));
        }
    } catch (error) {}
};
